#include "../bdm/stat/datasources.h"
#include "mex_parser.h"

namespace bdm {
/*!
* \brief Memory storage of off-line data column-wise

The data are stored in an internal matrix \c Data . Each column of Data corresponds to one discrete time observation \f$t\f$. Access to this matrix is via indices \c rowid and \c delays.

The data can be loaded from a file.
*/
class MexDS : public MemDS {
		//!Default constructor
	MexDS () {};

	/*! \brief Create memory data source from mxArray

	\code
	system={
		type="mexDS";
		varname="";            // name of workspace variable
		rids=[1 1 1];          // numbers of data rows
		tds =[0 1 2];          // time delays
		};
	\endcode

	MemDS with the above fields will be created;

	\todo Very memory inefficient implementation. The data file is copied 2 times! 
	For better implementatin we would need MemDS with pointer to the raw data. Then it could operate directly inside mxArray.

	*/
	void from_setting( const Setting &set )
	{	
		Data = mxArray2mat(mexGetVariable("base",set["varname"]));
		UI::get( rowid, set, "rids" , UI::compulsory);
		it_assert_debug ( max ( rowid ) <=Data.rows(),"MemDS rowid is too high for given Dat." );

		UI::get( delays, set, "tds", UI::compulsory );
		time = max ( delays );
		it_assert_debug ( time < Data.cols(),"MemDS delays are too high." );

		RV* r = UI::build<RV>(set,"rv", UI::compulsory);
		RV ru=RV();
		set_rvs(*r,ru);
	}


	// TODO dodelat void to_setting( Setting &set ) const;
};

UIREGISTER(MexDS);

}