#include "egiw_harness.h"
#include "stat/exp_family.h"
#include "mat_checks.h"
#include "test_util.h"
#include "UnitTest++.h"

namespace bdm {

void egiw_harness::from_setting(const Setting &set) {
    epdf_harness::from_setting(set);				
    UI::get(lognc, set, "lognc", UI::compulsory);
}

void egiw_harness::test(const char *config_name, int idx)
{
    epdf_harness::test(config_name, idx);

    CurrentContext cc(config_name, idx);

    egiw *wide = dynamic_cast<egiw *>(get_epdf());
    CHECK(wide);

    CHECK_CLOSE_EX(lognc, wide->lognc(), get_tolerance());
}

}
