#define BDMLIB // not an ideal way to prevent double registration of UI factories...
#include "base/loggers.h"
#include "test_util.h"
#include "osutils.h"
#include "UnitTest++.h"
#include <string>
#include <sys/stat.h>
#include <sys/types.h>

using namespace bdm;

TEST(test_dirfilelog)
{
    RV th = RV("{alog blog }");
    RV r = RV("{r }", "2");

    string ls("exp");
    remove_all(ls.c_str());
    makedir(ls, false);
    remove_all("exp/dirfile");

    dirfilelog L("exp/dirfile", 10);

    int rid;
    int thid;

    rid = L.add(r, "");
    thid = L.add(th, "th");

    L.init();

    for (int i = 0; i < 150; i++) {
	    L.logit(rid, vec_2((double)i, (double)(i + 1)));
	    L.logit(thid, vec_2((double)(100 - i), (double)(i - 50)));
	    L.step();
    }

    L.finalize();

    std::string expected(load_test_file("dirfile-format.matrix"));
    std::string actual(load_test_file("exp/dirfile/format"));
    CHECK_EQUAL(expected, actual);
}
