/*!
  \file
  \brief Agenda item format for stress tests of BDM matrices.
  \author Vaclav Barta.

  -----------------------------------
  BDM++ - C++ library for Bayesian Decision Making under Uncertainty

  Using IT++ for numerical operations
  -----------------------------------
*/

#ifndef SQUARE_MAT_POINT_H
#define SQUARE_MAT_POINT_H

#include "itpp_ext.h"
#include "bdmroot.h"

/*! Testing matrix operations needs one square symmetrical matrix, one
  random vector and one random scalar.
 */
class square_mat_point : public bdm::root
{
private:
    itpp::mat matrix;
    itpp::vec vector;
    double scalar;

public:
    square_mat_point():scalar(0) { }

    itpp::mat get_matrix() const {
	return matrix;
    }

    itpp::vec get_vector() const {
	return vector;
    }

    double get_scalar() const {
        return scalar;
    }

    void set_parameters(const itpp::mat &m, const itpp::vec &v, double s) {
        matrix = m;
	vector = v;
	scalar = s;
    }

    //! Load from structure with elements:
    //!  \code
    //! { matrix = ( "matrix", ...
    //!   vector = [ ...
    //!   scalar = ...
    //! }
    //! \endcode
    //! All elements are mandatory.
    void from_setting(const Setting &set);
  
    void to_setting(Setting &set) const;
};

#endif

