//
// C++ Implementation: osutils
//
// Description:
//
//
// Author: smidl <smidl@utia.cas.cz>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "osutils.h"
#include <iostream>

#ifdef WIN32
#include <direct.h>
#else
#include <sys/types.h>
#include <sys/stat.h>
#endif

#include <fcntl.h>
#include <errno.h>


void get_fname ( char* filename, string &dirname, string &f ) {
#ifdef WIN32
	sprintf ( filename, "%s\\%s", dirname.c_str(), f.c_str() );
#else
	sprintf ( filename, "%s/%s", dirname.c_str() , f.c_str() );
#endif
}

void makedir ( string &dirname, bool rewrite ) {
#ifdef WIN32
	if ( _mkdir ( dirname.c_str() ) == -1 )   // Create the directory
#else
	if ( mkdir ( dirname.c_str(), 00755 ) == -1 )   // Create the directory
#endif
	{
		if ( ( rewrite ) && ( errno == EEXIST ) ) it_warning ( "rewriting directory" );
		else it_error ( "dirfilelog:: cannot create directory" );
	}
}
