/*!
  \file
  \brief Generating stress test agenda from random data.
  \author Vaclav Barta.

  -----------------------------------
  BDM++ - C++ library for Bayesian Decision Making under Uncertainty

  Using IT++ for numerical operations
  -----------------------------------
*/

#ifndef SIZE_GENERATOR_H
#define SIZE_GENERATOR_H

#include "itpp_ext.h"
#include "generator.h"

/*! Generates progressively larger random matrices.
 */
class size_generator : public generator
{
private:
    int step;
    int sz;

public:
    size_generator():step(7), sz(step) { }

    itpp::mat next();

    //! Load from structure with elements:
    //!  \code
    //! { size = 7; // size (rows == cols) of the first generated matrix
    //!   step = 7; // how many times to increase the generated matrix in every iteration
    //! }
    //! \endcode
    //! Both elements are optional, with defaults as shown.
    void from_setting(const Setting &set);
};

#endif
