#include "size_generator.h"
#include "base/user_info.h"

using namespace itpp;
using bdm::UI;

void size_generator::from_setting ( const Setting &set ) {
	if ( set.exists ( "size" ) ) {
		UI::get ( sz, set, "size" );
	}

	if ( set.exists ( "step" ) ) {
		UI::get ( step, set, "step" );
	}
}

mat size_generator::next() {
	mat A0 = randu ( sz, sz );
	mat A = A0 * A0.T();
	sz *= step;
	return A;
}
