/*!
  \file
  \brief Support for testing descendants of mpdf.
  \author Vaclav Barta.

  -----------------------------------
  BDM++ - C++ library for Bayesian Decision Making under Uncertainty

  Using IT++ for numerical operations
  -----------------------------------
*/

#ifndef MPDF_HARNESS_H
#define MPDF_HARNESS_H

#define BDMLIB // not an ideal way to prevent double registration of UI factories...

#include "bdmroot.h"
#include "itpp_ext.h"
#include "shared_ptr.h"
#include "base/bdmbase.h"
#include "base/user_info.h"

namespace bdm {

class mpdf_harness : public root {
private:
	shared_ptr<mpdf> hmpdf;
	vec cond;
	vec mean;
	int nsamples;
	mat R;
	double tolerance;

public:
	static void test_config ( const char *config_file_name );

	mpdf_harness() : nsamples ( 1000 ), tolerance ( 0.1 ) { }

	virtual void test ( const char *config_name, int idx );

	void from_setting ( const Setting &set );

protected:
	mpdf *get_mpdf() {
		return hmpdf.get();
	}
};

}

#endif
