/*!
  \file
  \brief Support for testing descendants of epdf.
  \author Vaclav Barta.

  -----------------------------------
  BDM++ - C++ library for Bayesian Decision Making under Uncertainty

  Using IT++ for numerical operations
  -----------------------------------
*/

#ifndef EPDF_HARNESS_H
#define EPDF_HARNESS_H

#define BDMLIB // not an ideal way to prevent double registration of UI factories...

#include "bdmroot.h"
#include "itpp_ext.h"
#include "shared_ptr.h"
#include "base/bdmbase.h"
#include "base/user_info.h"
#include "stat/emix.h"

namespace bdm {

class epdf_harness : public root {
private:
	shared_ptr<epdf> hepdf;
	vec mean;
	vec variance;
	mat support;
	ivec nbins;
	int nsamples;
	mat R;
	shared_ptr<RV> mrv;
	double tolerance;

public:
	static void test_config ( const char *config_file_name );

	epdf_harness() : nsamples ( 1000 ), tolerance ( 0.1 ) { }

	virtual void test ( const char *config_name, int idx );

	void from_setting ( const Setting &set );

protected:
	epdf *get_epdf() {
		return hepdf.get();
	}

	double get_tolerance() const {
		return tolerance;
	}

private:
	// assumes support is valid
	void check_support_mean();

	// assumes support is valid
	void check_support_integral();

	// assumes R is valid - it probably shouldn't, but calling it
	// unconditionally leads to a lot of not implemented
	// functions...
	void check_sample_mean();

	// assumes R is valid
	void check_covariance();

	// assumes marginal_rv is valid
	void check_cond_mean( mprod &mep );

	// assumes marginal_rv and R are valid
	void check_cond_covariance( mprod &mep );
};

}

#endif
