/*!
 * \file
 * \brief Bayesian Models (bm) that use Bayes rule to learn from observations
 * \author Vaclav Smidl.
 *
 * -----------------------------------
 * BDM++ - C++ library for Bayesian Decision Making under Uncertainty
 *
 * Using IT++ for numerical operations
 * -----------------------------------
 */

#ifndef BM_H
#define BM_H

#include <itpp/itbase.h>
//#include <std>

using namespace itpp;

//! Class representing variables, most often random variables
class RV {
int len;
ivec ids;
ivec sizes;
ivec times;
ivec obs;
Array<std::string> names;

public:
 //! Full constructor which is called by the others
 RV(ivec in_ids, Array<std::string> in_names, ivec in_sizes, ivec in_times, ivec in_obs);
 //! default constructor 
 RV(ivec ids);
 friend std::ostream &operator<<(std::ostream &os, const RV &rv);
};




//! Class representing function of variables
class fnc {
RV rv;
};

//! Bayesian Model of the world, i.e. all uncertainty is modeled by probabilities.
class BM {
public:
//! Incremental Bayes rule
void bayes(vec dt);
//! Batch Bayes rule (columns of Dt are observations)
virtual void bayes(mat Dt);
};

//! Probability density function with numerical statistics, e.g. posterior density.
class epdf {
RV rv;
public:
//! Returns the required moment of the epdf
virtual vec moment(const int order = 1);
};

//! Conditional probability density, e.g. modeling some dependencies. 
class mpdf {
//! modeled random variable
RV rv;
//! random variable in condition
RV rvc;
public:

//! Returns the required moment of the epdf
virtual fnc moment(const int order = 1);
};

#endif // BM_H
