#include "base/user_info.h"
#include "stat/exp_family.h"
#include "itpp_ext.h"
#include "epdf_harness.h"
#include "mat_checks.h"
#include "UnitTest++.h"

using namespace bdm;

TEST ( test_egamma ) {
	epdf_harness::test_config ( "egamma.cfg" );
}

TEST ( test_enorm ) {
	epdf_harness::test_config ( "enorm.cfg" );
}

TEST ( test_ewishart ) {
	mat wM = "1.0 0.9; 0.9 1.0";
	eWishartCh eW;
	eW.set_parameters ( wM / 100, 100 );
	mat mea = zeros ( 2, 2 );
	mat Ch;
	for ( int i = 0; i < 100; i++ ) {
		Ch = eW.sample_mat();
		mea += Ch.T() * Ch;
	}

	mat observed ( "0.978486 0.88637; 0.88637 0.992141" );
	mat actual = mea / 100;
	CHECK_CLOSE ( observed, actual, 0.1 );
}

TEST ( test_rwiwishart ) {
	mat wM = "1.0 0.9; 0.9 1.0";
	rwiWishartCh rwW;
	rwW.set_parameters ( 2, 0.1, "1 1", 0.9 );
	mat mea = zeros ( 2, 2 );
	mat wMch = chol ( wM );
	mat Ch ( 2, 2 );
	for ( int i = 0; i < 100; i++ ) {
		vec tmp = rwW.samplecond ( vec ( wMch._data(), 4 ) );
		copy_vector ( 4, tmp._data(), Ch._data() );
		mea += Ch.T() * Ch;
	}

	mat observed ( "0.99464 0.885458; 0.885458 1.01853" );
	mat actual = mea / 100;
	CHECK_CLOSE ( observed, actual, 0.1 );
}
