#include <itpp/itbase.h>
#include "../bdm/stat/libBM.h"

#include "pmsm.h"

using namespace itpp;

//These lines are needed for use of cout and endl
using std::cout;
using std::endl;

int main()
{
	vec x0 = "100 120 100 2";
	vec u0 = "1 1";
	double h=1e-6;
	
	IMpmsm I;
	I.set_parameters ( 0.28, 0.003465, h, 0.1989,   1.5 ,4.0, 0.04, 0.0 );
	
	vec x(x0);	x(0) += h;
	cout << (I.eval(x,u0)-I.eval(x0,u0))/h <<endl;
	x=x0;	x(1) += h;
	cout << (I.eval(x,u0)-I.eval(x0,u0))/h <<endl;
	x=x0;	x(2) += h;
	cout << (I.eval(x,u0)-I.eval(x0,u0))/h <<endl;
	x=x0;	x(3) += h;
	cout << (I.eval(x,u0)-I.eval(x0,u0))/h <<endl;
	cout << endl;
	mat A(4,4);
	I.dfdx_cond(x0,u0,A);
	
	cout <<A.T() << endl;
	//Exit program:
	return 0;

}
