% Random Variables
a=struct('class','RV','names',{{'a'}});
b=struct('class','RV','names',{{'b'}});
ab=struct('class','RV','names',{{'a','b'}});

% Normal densities
N1a.class= 'enorm<ldmat>';
N1a.mu   = 3;
N1a.R    = 1;
N1a.rv   = a;

N2a = struct('class','enorm<ldmat>',...
    'mu',-3,...
    'R',  2,...
    'rv', a);

N1b.class= 'enorm<ldmat>';
N1b.mu   = 7;
N1b.R    = 1;
N1b.rv   = b;

% Gamma densities
Ga = struct('class','egamma',...
    'alpha',2,...
    'beta', 2,...
    'rv', a);

% 2D sources
%Normal
Nab = struct('class','enorm<ldmat>',...
    'mu',[0,2],...
    'R',  [2 0; 0 0.5],...
    'rv', ab);
GiW = struct('class','egiw',...
    'V',4*[5 2; 2 1],...
    'nu',  4,...
    'dimx',  1,...
    'rv', ab);
Gb_a=struct('class','mgamma',  'beta',2,  'k',1,  'rv',b,  'rvc',a); % f(b|a)
Ga_ =struct('class','mepdf','epdf',Ga); % convert f(a) to f(a|)
Gba = struct('class','mprod',  'mpdfs',{{Gb_a,Ga_}});
