/*!
  \file
  \brief Stress test generation base.
  \author Vaclav Barta.

  -----------------------------------
  BDM++ - C++ library for Bayesian Decision Making under Uncertainty

  Using IT++ for numerical operations
  -----------------------------------
*/

#ifndef GENERATOR_H
#define GENERATOR_H

#include "itpp_ext.h"
#include "bdmroot.h"

/*! An input iterator over IT++ matrices.
 */
class generator : public bdm::root {
public:
	generator();

	//! Generates a matrix. Returned matrices should become
	//! progressively more complicated.
	virtual itpp::mat next() = 0;
};

#endif
