#include "ctrlbase.h"

namespace bdm{

void LQG::set_system_parameters(const mat &A0, const mat &B0, const mat &C0){
	dimx = A0.rows();
	dimy = C0.rows();
	dimu = B0.cols();

	bdm_assert_debug ( A0.cols() == dimx, "LQG: A is not square" );
	bdm_assert_debug ( B0.rows() == dimx, "LQG: B is not compatible" );
	bdm_assert_debug ( C0.cols() == dimx, "LQG: C is not square" );

	A=A0;
	B=B0;
	C=C0;
	pr=zeros(dimx+dimu+dimy,  dimu+dimx+dimu+dimy);
	pr.set_submatrix(dimx, dimu+dimx, eye(dimu+dimy));
}

void LQG::set_control_parameters(const mat &Qy0, const mat &Qu0, const vec y_req0, int horizon0){
	bdm_assert_debug ( Qy0.cols() == dimy, "LQG: wrong dimensions of Qy " );
	bdm_assert_debug ( Qu0.cols() == dimu, "LQG: wrong dimensions of Qu " );
	bdm_assert_debug ( y_req0.length() == dimy, "LQG: wrong dimensions of y_req " );

	Qy=Qy0;
	Qu=Qu0;
	y_req=y_req0;
	horizon = horizon0;
	prepare_qr();
}

void LQG::prepare_qr(){
	// set parameter matrix
	pr.set_submatrix(0,0,B);
	pr.set_submatrix(0,dimu, A);
	
	//penalization
	qux=zeros(dimu,dimx+2*dimu+dimy);     
	qux.set_submatrix(0,0,Qu);
	qux.set_submatrix(0,dimx+dimu+dimy,Qu);

	qyx=zeros(dimy, dimx+dimy+dimu);
	qyx.set_submatrix(0,0,C);
	qyx.set_submatrix(0,dimx,-eye(dimy));
	
	//
	s=1e-5*eye(4);//dimx+dimu+dimy);
	// parts of QR
	hqy=Qy*qyx*pr;
	
	// pre_qr
	pre_qr = concat_vertical(s*pr, concat_vertical(hqy, qux));
	post_qr = zeros(pre_qr.rows(), pre_qr.cols());
}

}
