#include "ctrlbase.h"

namespace bdm{

void LQG::set_system(shared_ptr<StateSpace<fsqmat> > S0){
	S = S0;
	dimx= S->_dimx();
	dimy= S->_dimy();
	dimu= S->_dimu();
	pr=zeros(dimx+dimu+dimy,  dimu+dimx+dimu+dimy);
	pr.set_submatrix(dimx, dimu+dimx, eye(dimu+dimy));
}

void LQG::set_control_parameters(const mat &Qy0, const mat &Qu0, const vec &y_req0, int horizon0){
	Qy=Qy0;
	Qu=Qu0;
	y_req=y_req0;
	horizon = horizon0;
	validate();
	initialize();
}

void LQG::validate() {
	bdm_assert_debug ( Qy.cols() == dimy, "LQG: wrong dimensions of Qy " );
	bdm_assert_debug ( Qu.cols() == dimu, "LQG: wrong dimensions of Qu " );
	bdm_assert_debug ( y_req.length() == dimy, "LQG: wrong dimensions of y_req " );
}

void LQG::initialize(){
	// set parameter matrix
	pr.set_submatrix(0,0,S->_B());
	pr.set_submatrix(0,dimu, S->_A());
	
	//penalization
	qux=zeros(dimu,dimx+2*dimu+dimy);     
	qux.set_submatrix(0,0,Qu);
	qux.set_submatrix(0,dimx+dimu+dimy,Qu);

	qyx=zeros(dimy, dimx+dimy+dimu);
	qyx.set_submatrix(0,0,S->_C());
	qyx.set_submatrix(0,dimx,-eye(dimy));
	
	//
	s=1e-5*eye(dimx+dimu+dimy);
	// parts of QR
	hqy=Qy*qyx*pr;
	
	// pre_qr
	pre_qr = concat_vertical(s*pr, concat_vertical(hqy, qux));
	post_qr = zeros(pre_qr.rows(), pre_qr.cols());
}

}
