#ifndef MXDS_H
#define MXDS_H


#include "../bdm/bdmerror.h"
#include "../bdm/base/datasources.h"
#include "mex_parser.h"

namespace bdm {
/*!
* \brief Memory storage of off-line data column-wise

The data are stored in an internal matrix \c Data . Each column of Data corresponds to one discrete time observation \f$t\f$. Access to this matrix is via indices \c rowid and \c delays.

The data can be loaded from a file.
*/
class mxArrayDS : public MemDS {
	public:
	//!Default constructor
	mxArrayDS ():MemDS() {};

	/*! \brief Create memory data source from mxArray

	\code
	system={
		type="mexDS";
		varname="";                // name of workspace variable
		row_rv = {class='RV',...}  // definition of 
		};
	\endcode

	MemDS with the above fields will be created;

	*/
	void from_setting ( const Setting &set ) {
		Data = mxArray2mat ( mexGetVariable ( "base", set["varname"] ) );
/*		UI::get ( rowid, set, "rids" , UI::compulsory );
		bdm_assert_debug ( max ( rowid ) <= Data.rows(), "MemDS rowid is too high for given Dat." );

		UI::get ( delays, set, "tds", UI::compulsory );
		time = max ( delays );
		bdm_assert_debug ( time < Data.cols(), "MemDS delays are too high." );
*/
		//set MemDS
		rowid = linspace(0,Data.rows()-1);
		delays = zeros_i(Data.rows());
		dtsize=rowid.length();
		utsize=0;
		
		shared_ptr<RV> r = UI::build<RV> ( set, "rv", UI::optional );
		RV ru = RV();
		if (r){
			set_rvs ( *r, ru );
		} else {
			RV def((const char*)set["varname"],Data.rows());
			set_rvs(def, ru);
		}
	}


	// TODO dodelat void to_setting( Setting &set ) const;
};

UIREGISTER ( mxArrayDS );
SHAREDPTR ( mxArrayDS );

}
#endif //MXDS_H
