/************************************
        Extended Kalman Filter
        Matrix operations

        Z. Peroutka

Rev. 15.3.2008

15.3. 2008      Kompletni kontrola vypoctu + zamena q15->int a q30->long

*************************************/

/* Vsechny meze se udavaji ve tvaru (rozmer_matice - 1), abych mel ve FOR konstantni horni mez) */

/* Matrix addition in q15: m1 + m2 = result[rows, columns] */
extern void madd(int *m1, int *m2, int *result, unsigned int rows, unsigned int columns);

/* add diagonal matrix m2 to matrix m1 - both in format q15, minrowcol = min(rows, columns) */
extern void maddD(int *m1, int *m2, unsigned int minrowcol, unsigned int columns);

/* Matrix substraction in q15: m1 - m2 = result[rows, columns] */
extern void msub(int *m1, int *m2, int *result, unsigned int rows, unsigned int columns);

/* Matrix multiply in q15: m1[rows,columnsx]*m2[columnsx,columns] = result[rows,columns] */
extern void mmult(int *m1, int *m2, int *result, unsigned int rows, unsigned int columnsx, unsigned int
columns);

/* Matrix multiplication in q15: m1[rows,columnsx]*(m2[columnsx,columns]transpose) = result[rows,columns] */
extern void mmultt(int *m1, int *m2, int *result, unsigned int rows, unsigned int columnsx, unsigned int
columns);

/* matrix multiplication in q15: sum is in q15 */
extern void mmult15(int *m1, int *m2, int *result, unsigned int rows, unsigned int columnsx, unsigned int
columns);

/* Matrix multiplication in q15 (sum is in q15): m1[rows,columnsx]*(m2[columns,columnsx]transpose) = result[rows,columns] */
extern void mmultt15(int *m1, int *m2, int *result, unsigned int rows, unsigned int columnsx, unsigned int
columns);

/* Matrix multiplication - Q15 * Q30 format -> RESULT in Q15 */
extern void mmult1530(int *m1, long *m2, int *result, unsigned int rows, unsigned int columnsx, unsigned int
columns);

/* Left matrix multiplication with DIAG ones matrix in q15: DIAG[rows,columnsx]*m2[columnsx,columns] = result[rows,columns]
minrowcol=minimum(rows, columnsx) */
extern void mmultDl(int *m2, int *result, unsigned int rows, unsigned int columnsx, unsigned int
columns, unsigned int minrowcol);

/* Left matrix multiplication with DIAG matrix in q15: DIAG[rows,columnsx]*m2[columnsx,columns] = result[rows,columns]
minrowcol=minimum(rows, columnsx) */
extern void mmultDl15(int *DIAG, int *m2, int *result, unsigned int rows, unsigned int columnsx, unsigned int
columns, unsigned int minrowcol);

/* Right matrix multiplication with DIAG ones matrix in q15: m1[rows,columnsx]*DIAG[columnsx,columns] = result[rows,columns]
minrowcol=minimum(columnsx,columns) */
extern void mmultDr(int *m1, int *result, unsigned int rows, unsigned int columnsx, unsigned int
columns, unsigned int minrowcol);

/* Right matrix multiplication with DIAG matrix in q15: m1[rows,columnsx]*DIAG[columnsx,columns] = result[rows,columns]
minrowcol=minimum(columnsx,columns) */
extern void mmultDr15(int *m1, int *DIAG, int *result, unsigned int rows, unsigned int columnsx, unsigned int
columns, unsigned int minrowcol);

/* Matrix transposition in q15: m1.' = result[rows, columns] */
extern void mtrans(int *m1, int *result, unsigned int rows, unsigned int columns);

/* Matrix [2,2] inversion in q15: inv(m1) = result[rows, columns] */
extern void minv2(int *matrix, long *result);

extern void choice_P(int *m, int *result, unsigned int columns);
extern void choice_x(int *m, int *result);

