#include <itpp/itbase.h>
#include "libBM.h"
#include "itpp_ext.h"

using namespace itpp;

using std::cout;

void RV::init( ivec in_ids, Array<std::string> in_names, ivec in_sizes, ivec in_times, ivec in_obs ) {
	//
	len = in_ids.length();
	//PRUDENT_MODE
	// All vetors should be of same length
	if ( 	 ( len != in_ids.length() ) || \
	        ( len != in_names.length() ) || \
	        ( len != in_sizes.length() ) || \
	        ( len != in_times.length() ) || \
	        ( len != in_obs.length() ) ) {
		it_error( "RV::RV inconsistent length of input vectors." );
	}

	ids = in_ids;
	names = in_names;
	sizes = in_sizes;
	times = in_times;
	obs = in_obs;
};

RV::RV ( ivec in_ids, Array<std::string> in_names, ivec in_sizes, ivec in_times, ivec in_obs ) {
	init ( in_ids, in_names, in_sizes, in_times, in_obs );
}

RV::RV ( ivec in_ids ) {
	
	len = in_ids.length();
	Array<std::string> A( len );
	std::string rvstr = "rv";

	for ( int i = 0; i < len;i++ ) {
		A( i ) = rvstr + to_str(i);
	}

	init ( in_ids, A, ones_i( len ), zeros_i( len ), zeros_i( len ) );
}

RV RV::rvsubselect(ivec ind){
	return RV(ids(ind), names(to_Arr(ind)), sizes(ind), times(ind), obs(ind));
}

RV RV::operator()(ivec ind){
	return RV(ids(ind), names(to_Arr(ind)), sizes(ind), times(ind), obs(ind));
}

std::ostream &operator<<( std::ostream &os, const RV &rv ) {

	for ( int i = 0; i < rv.len ;i++ ) {
		os << rv.ids( i ) << "(" << rv.sizes( i ) << ")" <<  // id(size)=
		"=" << rv.names( i )  << "_{"  << rv.times( i ) << "}; "; //name_{time}
	}
	return os;
}

