/*!
 * \file
 * \brief Matrices in decomposed forms (LDL', LU, UDU', etc).
 * \author Vaclav Smidl.
 *
 * -----------------------------------
 * BDM++ - C++ library for Bayesian Decision Making under Uncertainty
 *
 * Using IT++ for numerical operations
 * -----------------------------------
 */

#include <itpp/itbase.h>

using namespace itpp;

class LD
{
	public:

		/**
		 * Perfroms a dyadic update $V = V + w v v'$
		 * @param  v Vector forming the dyad to be added
		 * @param  w weight of the updating dysad
		 */
		void ldupdt ( vec v, double w = 1.0 );

		//! Construct by copy of L and D.
		LD ( mat L, vec D );
		//! Construct by decomposition of full matrix V.
		LD ( mat V );

	protected:
		vec D;
		mat L;

};

LD::LD ( const mat exL, const vec exD )
{
	D = exD;
	L = exL;
}

LD::LD ( const mat V )
{
	; //not implemneted yet
}

void LD::ldupdt ( vec v, double w )
{
	printf ( "not implemented" ); //TODO: VS
}
