#include "arx.h"

namespace bdm {

  struct str_aux {
	vec d0;
	double nu0;
	mat L0;
	mat L;
	vec d;
	double nu;
	ivec strL;                 // Current structure of L and d
	ivec strRgr;               // Structure elements currently inside regressor (after regressand)
	ivec strMis;               // structure elements, that are currently outside regressor (before regressand)
	int posit1;                // regressand position
	int nbits; 				   // number of bits available in double
	int bitstr; 
	double loglik;         	// loglikelihood
  };
  
ivec straux1(ldmat Ld, double nu, ldmat Ld0, double nu0, ivec belief, int nbest, int max_nrep, double lambda, int order_k, ivec &rgrsout){
// see utia_legacy/ticket_12/ implementation and str_test.m

const mat &L = Ld._L();
const vec &d = Ld._D();

const mat &L0 = Ld0._L();
const vec &d0 = Ld0._D();

int n_data = d.length();

ivec belief_out = find(belief==4)+1; // we are avoiding to put this into regressor
ivec belief_in  = find(belief==1)+1; // we are instantly keeping this in regressor

str_aux full;

full.d0  = d0;
full.nu0 = nu0;
full.L0  = L0;
full.L   = L;
full.d   = d;
full.nu  = nu;
full.strL = linspace(1,n_data);
full.strRgr = linspace(2,n_data);
full.strMis = ivec(0);                     
full.posit1 = 1;   
//full.nbits  = floor(log2(bitmax))-1;  //!!!!!!!

}



}
