#include "stat/exp_family.h"
#include "stat/merger.h"
#include "mat_checks.h"
#include "UnitTest++.h"

const double epsilon = 0.0001;

using namespace bdm;

TEST ( test_merger_base ) {
	RV x ( "{xmerger }", "1" );

	RV z ( x );

	enorm_fsqmat_ptr f1;
	f1->set_rv ( x );
	enorm_fsqmat_ptr f2;
	f2->set_rv ( x );

	f1->set_parameters ( "-5", mat ( "2" ) );
	f2->set_parameters ( "5", mat ( "10" ) );

	mpdf_array A ( 2 );
	A ( 0 ) = new mepdf ( f1 );
	A ( 1 ) = new mepdf ( f2 );

	int Npoints = 100;
	mat x_grid ( 1, Npoints );
	x_grid.set_row ( 0, linspace ( -10.0, 10.0 ) );

	vec l_f1 = f1->evallog_m ( x_grid );
	vec l_f2 = f2->evallog_m ( x_grid );
	mat lW ( 2, Npoints );
	lW.set_row ( 0, l_f1 );
	lW.set_row ( 1, l_f2 );

	merger_base M ( A );
	enorm<fsqmat> g0;
	g0.set_rv ( x );
	g0.set_parameters ( vec ( "0.0" ), mat ( "100.0" ) );

	M.set_method ( LOGNORMAL, 1.2 );
	M.set_support ( g0, 200 );
	M.merge ();

	vec m2 = M.merge_points ( lW );

	vec exp_f1 ( "-7.51551 -7.02066 "
		     "-6.54622 -6.09219 "
		     "-5.65856 -5.24534 "
		     "-4.85252 -4.48011 -4.1281 "
		     "-3.7965 -3.48531 -3.19452 "
		     "-2.92414 -2.67417 -2.4446 -2.23544 -2.04668 "
		     "-1.87833 -1.73039 -1.60285 -1.49572 -1.40899 -1.34267 -1.29676 -1.27125 -1.26615 -1.28145 -1.31717 -1.37328 -1.4498 -1.54673 -1.66407 -1.80181 -1.95996 "
		     "-2.13851 -2.33747 -2.55683 -2.79661 "
		     "-3.05678 -3.33737 -3.63836 -3.95975 "
		     "-4.30155 -4.66376 "
		     "-5.04638 -5.4494 -5.87282 "
		     "-6.31665 -6.78089 "
		     "-7.26554 -7.77059 "
		     "-8.29604 -8.84191 "
		     "-9.40818 -9.99485 "
		     "-10.6019 "
		     "-11.2294 -11.8773 "
		     "-12.5456 "
		     "-13.2343 -13.9434 "
		     "-14.6729 "
		     "-15.4229 "
		     "-16.1932 -16.9839 "
		     "-17.7951 "
		     "-18.6266 "
		     "-19.4786 "
		     "-20.3509 "
		     "-21.2437 "
		     "-22.1569 "
		     "-23.0905 "
		     "-24.0444 "
		     "-25.0188 "
		     "-26.0136 "
		     "-27.0288 "
		     "-28.0644 "
		     "-29.1205 "
		     "-30.1969 "
		     "-31.2937 "
		     "-32.4109 "
		     "-33.5486 "
		     "-34.7066 "
		     "-35.8851 "
		     "-37.0839 "
		     "-38.3032 "
		     "-39.5429 "
		     "-40.8029 "
		     "-42.0834 "
		     "-43.3843 "
		     "-44.7056 "
		     "-46.0473 "
		     "-47.4094 "
		     "-48.7919 "
		     "-50.1948 "
		     "-51.6182 "
		     "-53.0619 "
		     "-54.526 "
		     "-56.0106 "
		     "-57.5155" );
	CHECK_CLOSE(exp_f1, l_f1, epsilon);

	vec exp_f2 ( "-13.3202 -13.0192 "
		     "-12.7223 -12.4295 -12.1408 "
		     "-11.8561 -11.5755 -11.299 -11.0266 "
		     "-10.7582 -10.494 -10.2338 "
		     "-9.97772 -9.7257 -9.47777 -9.23391 "
		     "-8.99414 -8.75845 -8.52684 -8.29931 -8.07587 "
		     "-7.8565 -7.64122 -7.43002 -7.22289 -7.01985 "
		     "-6.82089 -6.62602 -6.43522 -6.2485 -6.06587 "
		     "-5.88732 -5.71284 -5.54245 -5.37614 -5.21392 -5.05577 "
		     "-4.9017 -4.75172 -4.60581 -4.46399 -4.32625 -4.19259 -4.06301 "
		     "-3.93752 -3.8161 -3.69876 -3.58551 -3.47634 -3.37125 -3.27024 -3.17331 -3.08046 "
		     "-2.99169 -2.90701 -2.8264 -2.74988 -2.67744 -2.60908 -2.5448 -2.4846 -2.42849 -2.37645 -2.3285 -2.28462 -2.24483 -2.20912 -2.17749 -2.14994 -2.12648 -2.10709 -2.09179 -2.08056 -2.07342 -2.07036 -2.07138 -2.07648 -2.08566 -2.09893 -2.11627 -2.1377 -2.16321 -2.1928 -2.22647 -2.26422 -2.30605 -2.35196 -2.40196 -2.45603 -2.51419 -2.57643 -2.64275 -2.71315 -2.78763 -2.8662 -2.94884 "
		     "-3.03557 -3.12637 -3.22126 -3.32023" );
	CHECK_CLOSE(exp_f2, l_f2, epsilon);

	vec exp_m2 ( "-7.95304 -7.47281 -7.01175 "
		     "-6.56987 -6.14716 "
		     "-5.74362 -5.35927 "
		     "-4.99408 -4.64808 -4.32125 -4.01359 "
		     "-3.72511 -3.45581 -3.20568 "
		     "-2.97473 -2.76295 -2.57035 -2.39692 -2.24267 -2.1076 "
		     "-1.9917 -1.89498 -1.81743 -1.75905 -1.71986 -1.69984 -1.69899 -1.71732 -1.75483 -1.81151 -1.88736 -1.9824 "
		     "-2.0966 -2.22999 -2.38255 -2.55428 -2.74519 -2.95528 "
		     "-3.18454 -3.43298 -3.70059 -3.98738 "
		     "-4.2008 -4.10829 -4.0211 "
		     "-3.93921 -3.86263 -3.79137 -3.72542 -3.66478 -3.60945 -3.55944 -3.51473 -3.47534 -3.44126 -3.41249 -3.38903 -3.37088 -3.35805 -3.35053 -3.34831 -3.35141 -3.35983 -3.37355 -3.39259 -3.41693 -3.44659 -3.48156 -3.52185 -3.56744 -3.61835 -3.67457 -3.73609 -3.80294 -3.87509 -3.95255 "
		     "-4.03533 -4.12342 -4.21682 -4.31553 -4.41955 -4.52889 -4.64353 -4.76349 -4.88876 "
		     "-5.01934 -5.15524 -5.29644 -5.44296 -5.59479 -5.75193 -5.91438 "
		     "-6.08214 -6.25522 -6.4336 -6.6173 -6.80631 "
		     "-7.00064 -7.20027 -7.40522" );
	CHECK_CLOSE(exp_m2, m2, epsilon);
}

TEST ( test_merger_base_sources ) {
	UIFile in ( "merger.cfg" );

	shared_ptr<merger_base> mb =
		UI::build<merger_base> ( in, "Merger", UI::compulsory );

	mpdf_array sources;
	UI::get ( sources, in, "Sources", UI::compulsory );
	mb->set_sources ( sources );

	shared_ptr<rectangular_support> support = 
		UI::build<rectangular_support> ( in, "Support", UI::compulsory );
	mb->set_support( *support );

	mb->merge();
	vec m = mb->mean();
	CHECK_EQUAL ( 2, m.size() );
}

TEST ( test_merger_base_sources_error ) {
	UIFile in ( "merger_error.cfg" );

	mpdf_array sources;
	try {
		UI::get ( sources, in, "Sources", UI::compulsory );
		CHECK ( false );
	} catch ( UISettingException &exc ) {
		CHECK ( exc.what() );
	}
}
