% Random Variables
a=struct('class','RV','names',{{'a'}});
b=struct('class','RV','names',{{'b'}});
ab=struct('class','RV','names',{{'a','b'}});

% Sources
f1.class= 'enorm<ldmat>';
f1.mu   = 5;
f1.R    = 1;
f1.rv   = b;

% merger 
Merger.class='merger_mix';
Merger.method='lognormal';
Merger.beta=1.2;
Merger.ncoms=20;
Merger.stop_niter=50;
Merger.effss_coef=1;
%Merger.dbg_file='merger_mix_dbg';


% 2D sources
f3 = struct('class','enorm<ldmat>',...
    'mu',[1,2],...
    'R',  [1 -0.5; -0.5 1],...
    'rv', ab);
f4 = struct('class','mlnorm<ldmat>',...
    'rv',a,...
    'rvc', b,...
    'A',  1,...
    'const', 0,...
    'R',1);
% 2D support
support2.grid={[-5,5],[0.001,9]};
support2.nbins=[30,30];

% 2D
%vy2=merger({f3,f1}, support2, Merger)
vy2=merger({f3,f4}, support2, Merger)

figure(2);
subplot(2,2,1);
contour_2(vy2.support(1,:),vy2.support(2,:),vy2.source1)
% set(gca,'XLim',[-5,5])
% set(gca,'YLim',[-1,7])
title('Source 1')
subplot(2,2,2);
contour_2(vy2.support(1,:),vy2.support(2,:),vy2.source2')
% set(gca,'XLim',[-5,5])
% set(gca,'YLim',[-1,7])
title('Source 2')

subplot(2,2,3);
hold off
contour_2(vy2.support(1,:),vy2.support(2,:),vy2.mix)
% set(gca,'XLim',[-5,5])
% set(gca,'YLim',[-1,7])
title('Mixture Approximation')

subplot(2,2,4);
hold off
plot(vy2.support(1,:),vy2.support(2,:),'.','MarkerSize',4)
hold on
contour_2(vy2.support(1,:),vy2.support(2,:),vy2.weights)
% set(gca,'XLim',[-5,5])
% set(gca,'YLim',[-1,7])
title('Weighted Empirical')

