% load data created by the MpdfDS_example
load mpdfds_results

DS.class   = 'MemDS';
DS.Data    = Data;
DS.drv     = drv;

%%%%%% ARX estimator

A1.class = 'ARX';
A1.rv = y;
A1.rgr = RVtimes([y,u],[-3,-1]) ; % correct structure is {y,y}
A1.options ='logbounds,logll';

M=estimator(DS,{A1});

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% plot results
ndat = size(M.u,1);
true_theta=[fy.A fy.const]; 
true_R=[fy.R]; 

subplot(1,2,1);
hold off
plot((true_theta' *ones(1,ndat))','-.');
title(' Regression parameters \theta')
hold on
plot(M.mean_theta(1:ndat,:));
co = get(gca,'ColorOrder');
for i=1:size(M.mean_theta,2)
    ind =1:10:ndat;
    h=errorbar(ind,M.mean_theta(ind,i),...
    M.mean_theta(ind,i)-M.lb_theta(ind,i),M.mean_theta(ind,i)-M.ub_theta(ind,i),'.');
    set(h,'color',co(i,:));
end

set(gca,'YLim',[-1.5,1]);

subplot(1,2,2);
hold off
plot(true_R*ones(1,ndat),'-.');
title('Variance parameters r')
hold on
plot(M.mean_r(1:ndat,:));
co = get(gca,'ColorOrder');
ind =1:10:ndat;
for i=1:size(M.mean_r, 2)
    h=errorbar(ind,M.mean_r(ind,i),...
    M.mean_r(ind,i)-M.lb_r(ind,i),M.mean_r(ind,i)-M.ub_r(ind,i),'.');
    set(h,'color',co(i,:));
end