#include "estim/arx.h"
#include "mat_checks.h"

using namespace bdm;

TEST(test_arx_straux){
mat A="0.8147    0.9134    0.2785;"
    "0.9058    0.6324    0.5469;"
    "0.1270    0.0975    0.9575";

mat B="0.9649    0.9572    0.1419;"
    "0.1576    0.4854    0.4218;"
    "0.9706    0.8003    0.9157";
//when updateing matrices do not forget to update CHECK_EQUAL below!!!
	
ldmat Ld0(3); Ld0.ldform(A,ones(3));
ldmat Ld1(3); Ld1.ldform(A+B,ones(3));


ivec belief = vec_1(2);           // default belief
int nbest = 3;           // nbest: how many regressors are returned
int nrep = 5;         // nrep: number of random repetions of structure estimation
double lambda   = 0.9; 
int k=2;

//[strout, rgrsout, statistics] = 
//          straux1(L, d, nu, L0, d0, nu0, belief, nbest, max_nrep, lambda,
//          order_k);
ivec o2;
ivec o1 = straux1(Ld1,20, Ld0, 10,  belief, nbest, nrep, lambda, k, o2);


CHECK_EQUAL(ivec("2 3"), o1);

}
