% configuracni struktura se bude jmenovat "c"
c.b =1;
c.sigma = 0.1;
c.ndat = 50;

yr = 1;

% nejlepsi mozny regulator - zna b
C1.class='exact_ctrl';
C1.yr   = yr;
C1.b    = c.b;

% CE regulator - b se odhaduje
C2.class='ce_ctrl';
C2.yr   = yr;
C2.b0   = -0.;
C2.P0   = 1;

c.controller = C1;
M1=iterativemc(c);

loss_exact = sum((M1.y-yr*ones(size(M1.y))).^2)
loss_theory = c.ndat*c.sigma^2

c.controller = C2;
M2=iterativemc(c);

loss_ce = sum((M2.y-yr*ones(size(M2.y))).^2)

% monte carlo study
n=100;
losses=zeros(10,1);
c.controller = C1;
seeds=32000*rand(1,n);
for i=1:n
    c.seed = seeds(i); 
    Mmc=iterativemc(c);
    losses(i) = sum((Mmc.y-yr*ones(size(Mmc.y))).^2);
end
[min(losses) mean(losses) max(losses)]
    