% load data created by the MpdfDS_example
load mpdfds_results

DS.class   = 'MemDS';
DS.Data    = Data;
DS.drv     = drv;

%%%%%% ARX estimator conditioned on frg

A1.class = 'ARXfrg';
A1.rv = y;
A1.rgr = RVtimes([y,u],[-3,-1]) ; 
A1.options ='logbounds,logll';
A1.frg = 0.9;
A1.name = 'A1';

%%%%%% Random walk on frg - Dirichlet 
phi_pdf.class = 'mDirich';         % random walk on coefficient phi
phi_pdf.rv    = RV('phi',2);       % 2D random walk - frg is the first element
phi_pdf.k     = 0.01;              % width of the random walk
phi_pdf.betac = [0.01 0.01];       % stabilizing elememnt of random walk

%%%%%% Combining estimators in Marginalized particle filter
E.class = 'MPF';
E.BM = A1;                         % ARX is the analytical part
E.parameter_pdf = phi_pdf;         % Random walk is the parameter evolution model
E.res_threshold = 1.0;             % resampling parameter
E.n = 20;                          % number of particles
E.prior.class = 'eDirich';         % prior on non-linear part
E.prior.beta  = [1 1]; % 
E.options ='logbounds,logll';
E.name = 'MPF';

M=estimator(DS,{E});

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% plot results
ndat = size(M.u,1);

figure(1);
subplot(2,2,1);
plotestimates(true_theta, M.MPFmean_theta, M.MPFlb_theta, M.MPFub_theta);
title(' Regression parameters \theta')
set(gca,'YLim',[-1.5,1]);

subplot(2,2,2);
plotestimates(true_R, M.MPFmean_r,M.MPFlb_r,M.MPFub_r);
title('Variance parameters r')

subplot(2,2,3);
plotestimates(1, M.MPFmean_phi(:,1),M.MPFlb_phi(:,1),M.MPFub_phi(:,1));
title('Forgetting factor')

