/*!
  \file
  \brief Bayesian Models (bm) that use Bayes rule to learn from observations
  \author Vaclav Smidl.

  -----------------------------------
  BDM++ - C++ library for Bayesian Decision Making under Uncertainty

  Using IT++ for numerical operations
  -----------------------------------
*/

#ifndef root_H
#define root_H

#include <string>

#include "itpp_ext.h"
#include "base/libconfig/libconfig.h++"

using namespace libconfig;
using namespace itpp;
using namespace std;

namespace bdm {

//! Root class of BDM objects
class root {
	//! level of details that will be logged to logger
	int log_level;
public:
	//! make sure this is a virtual object
	virtual ~root() {
	}

	//! This method returns a basic info about the current instance
	virtual string to_string() const {
		return "";
	}

	//! This method arrange instance properties according the data stored in the Setting structure
	virtual void from_setting ( const Setting &set ) {
	}

	//! This method save all the instance properties into the Setting structure
	virtual void to_setting ( Setting &set ) const {
	}

	//! This method TODO
	virtual void validate() {
	}
	
};

}; //namespace
#endif // root_H
