/*!
  \file
  \brief Bayesian Models (bm) that use Bayes rule to learn from observations
  \author Vaclav Smidl.

  -----------------------------------
  BDM++ - C++ library for Bayesian Decision Making under Uncertainty

  Using IT++ for numerical operations
  -----------------------------------
*/

#ifndef root_H
#define root_H

#include <string>

#include "itpp_ext.h"
#include "base/libconfig/libconfig.h++"

using namespace libconfig;
using namespace itpp;
using namespace std;

namespace bdm {

//! Root class of BDM objects
class root {
	protected:
	//! level of details that will be logged to logger
	int log_level;
	//! vector of log IDs - one element for each entry
	ivec log_ids;
public:
	//! make sure this is a virtual object
	virtual ~root() {
	}

	//! This method returns a basic info about the current instance
	virtual string to_string() const {
		return "";
	}

	//! This method arrange instance properties according the data stored in the Setting structure
	virtual void from_setting ( const Setting &set ) {
	}

	//! This method save all the instance properties into the Setting structure
	virtual void to_setting ( Setting &set ) const {
	}

	//! This method checks that all internal structures has been correctly set-up, always call at the ned of from_setting
	virtual void validate() {
	}
};

}; //namespace
#endif // root_H
