/*!
  \file
  \brief Bayesian Filtering for generalized autoregressive (ARX) model
  \author Vaclav Smidl.

  -----------------------------------
  BDM++ - C++ library for Bayesian Decision Making under Uncertainty

  Using IT++ for numerical operations
  -----------------------------------
*/

#ifndef STRAUX_H
#define STRAUX_H

namespace bdm {

	
struct str_aux {
	vec d0;
	double nu0;
	mat L0;
	mat L;
	vec d;
	double nu;
	ivec strL;                 // Current structure of L and d
	ivec strRgr;               // Structure elements currently inside regressor (after regressand)
	ivec strMis;               // structure elements, that are currently outside regressor (before regressand)
	int posit1;                // regressand position
	int nbits; 				   // number of bits available in double
	bvec bitstr; 
	double loglik;         	// loglikelihood
  };
  


struct str_statistics {
 long long int allstrs;
 int nrand;
 int unique;
 int to;
 double cputime_seconds;
 double itemspeed;
 int muto;
 ivec mutos;
 vec maxmutos;
};


	//! Rplication of Ludvik Tesar original straux1 from mixtools straux1
ivec straux1(ldmat Ld, double nu, ldmat Ld0, double nu0, ivec belief, int nbest, int max_nrep, double lambda, int order_k, Array<str_aux> &rgrsout);

}

#endif // STRAUX_H


