#include "../bdm/base/datasources.h"
#include "mat_checks.h"
#include "UnitTest++.h"

using namespace bdm;

TEST ( EpdfDS_test ) {
	UIFile uif("epdfds.cfg");

	shared_ptr<EpdfDS> ds=UI::build<EpdfDS>(uif, "ds");
	
	vec mean = zeros(2);
	vec dt = zeros(2);
	for (int i=0; i<100; i++){
		ds->step();
		ds->getdata(dt);
		mean += dt;
	}
	CHECK_CLOSE_EX (  vec_2(1.0,2.0) ,mean/100, 1e-2);
}

TEST ( PdfDS_test ) {
	UIFile uif("pdfds.cfg");

	shared_ptr<PdfDS> ds=UI::build<PdfDS>(uif, "ds", UI::compulsory);
	
	vec dt = zeros(2);
	vec ut="1.0";
	ds->write(ut);
	for (int i=0; i<100; i++){
		ds->step();
	}
	ds->getdata(dt);
	CHECK_CLOSE ( -0.2 , dt(0), 1e-4);

	ut="2.0";
	ds->write(ut);
	for (int i=0; i<100; i++){
		ds->step();
	}
	ds->getdata(dt);
	CHECK_CLOSE ( -0.4 , dt(0), 1e-4);
}
