
#include "stat/exp_family.h"
#include "stat/merger.h"

using namespace bdm;

using namespace bdm;

//These lines are needed for use of cout and endl
using std::cout;
using std::endl;

int main() {

	RNG_randomize();

	RV x ( "{x }", "1" );
	RV y ( "{y }", "1" );

	RV xy = x;
	xy.add ( y );

	enorm_fsqmat_ptr f1;
	f1->set_rv ( xy );
	enorm_fsqmat_ptr f2;
	f2->set_rv ( xy );
	enorm_fsqmat_ptr f3;
	f3->set_rv ( y );

	f1->set_parameters ( "4 3", mat ( "0.4 0.3; 0.3 0.4" ) );
	f2->set_parameters ( "1 3", mat ( "0.3 -0.2; -0.2 0.3" ) );
	f3->set_parameters ( "2", mat ( "0.4" ) );

	pdf_array A ( 3 );
	A ( 0 ) = f1;
	A ( 1 ) = f2;
	A ( 2 ) = f3;

	int Npoints = 100;
	mat x_grid ( 1, Npoints );
	x_grid.set_row ( 0, linspace ( -2.0, 4.0, Npoints ) );
	mat y_grid ( 1, Npoints );
	y_grid.set_row ( 0, linspace ( -2.0, 4.0, Npoints ) );

	mat Grid ( 2, Npoints*Npoints );
	Grid.set_submatrix ( 0, 0, kron ( x_grid, ones ( 1, Npoints ) ) );
	Grid.set_submatrix ( 1, 0, kron ( ones ( 1, Npoints ), y_grid ) );

	merger_mix M ( A );
	enorm<fsqmat> g0;
	g0.set_rv ( xy );
	g0.set_parameters ( vec ( "4 4" ), mat ( "1 0; 0 1" ) );

	M.set_parameters ( 5 );
	M.set_method ( LOGNORMAL, 1.2 );
	M.set_support ( g0, 400 );
	M.merge();

	MixEF &MM = M._Mix();
	epdf* MP = MM.epredictor();//xy

	vec Res1 = M.evallog_mat ( Grid );
	mat Res2 = ( ( emix* ) MP )->evallog_mat ( Grid );

	it_file it ( "merger_iter_test.it" );
	it << Name ( "Npoints" ) << Npoints;
	it << Name ( "Grid" ) << Grid;
	it << Name ( "Res1" ) << Res1;
	it << Name ( "Res2" ) << Res2;
}
