#include "estim/arx.h"
#include "../mat_checks.h"

using namespace bdm;

TEST ( arx_straux_test ) {

	UIFile F ( "arx_straux_test.cfg" );

	Setting &tests=F.getRoot() ["tests"];
	for ( int i=0;i<tests.getLength(); i++ ) {
		mat A;
		mat B;
		ivec o1_ok;
		UI::get ( A,tests[i],"A",UI::compulsory );
		UI::get ( B,tests[i],"B",UI::compulsory );
		UI::get ( o1_ok,tests[i],"o1",UI::compulsory );

//when updateing matrices do not forget to update CHECK_EQUAL below!!!

		ldmat Ld0 ( 3 ); Ld0.ldform ( A,ones ( A.rows() ) );
		ldmat Ld1 ( 3 ); Ld1.ldform ( A+B,ones ( A.rows() ) );


		ivec belief = vec_1 ( 2 );        // default belief
		int nbest = 3;           // nbest: how many regressors are returned
		int nrep = 5;         // nrep: number of random repetions of structure estimation
		double lambda   = 0.9;
		int k=2;

//[strout, rgrsout, statistics] =
//          straux1(L, d, nu, L0, d0, nu0, belief, nbest, max_nrep, lambda,
//          order_k);
		Array<str_aux> o2;
		ivec o1 = straux1 ( Ld1,20, Ld0, 10,  belief, nbest, nrep, lambda, k, o2 );

//o1 is messed up in matlab's straux
		sort ( o1_ok );
		sort ( o1 );
		CHECK_EQUAL ( o1_ok, o1 );
	}

}
