#include "base/bdmbase.h"
#include "base/user_info.h"
#include "stat/exp_family.h"
#include "stat/discrete.h"
#include "itpp_ext.h"
#include "../epdf_harness.h"
#include "../mat_checks.h"
#include "UnitTest++.h"

const double epsilon = 0.00001;

using namespace bdm;

TEST ( egiw_test ) {
	epdf_harness::test_config ( "egiw.cfg" );
}

TEST ( egiw_1_2_test ) {
	// Setup model
	double mu = 1.1; //unit step parametr
	double b = 3.0; // sequence of <1 -1 1 -1...>
	double s = 0.1;


	// TEST 1x1 EGIW
	mat V ( 3, 3 );
	V ( 0, 0 ) = pow ( mu, 2 ) + pow ( b, 2 ) + s;
	V ( 1, 0 ) = mu;
	V ( 2, 0 ) = b;

	V ( 0, 1 ) = V ( 1, 0 );
	V ( 1, 1 ) = 1.0;
	V ( 2, 1 ) = 0.0;

	V ( 0, 2 ) = V ( 2, 0 );
	V ( 1, 2 ) = V ( 2, 1 );
	V ( 2, 2 ) = 1.0;

	double nu = 20;

	egiw E ( 1, nu * V, nu );
	CHECK_CLOSE ( vec ( "1.1 3.0 0.142857" ), E.mean(), epsilon );
	CHECK_CLOSE ( 7.36731, E.lognc(), epsilon );

	int n = 100;
	rectangular_support Sup;
	Sup.set_parameters("{[-2.,4.], [1.,5.], [0.,2.]} ", n*ones_i(E.dimension()));
	
	double summ = exp(E.evallog(Sup.first_vec()));
	// sum all likelihood at all points of support
	for ( int k = 1; k < Sup.points(); k++ ) { // ALL b
		summ += exp (E.evallog(Sup.next_vec()));
	}

	CHECK_CLOSE ( 1.0, summ*prod(Sup._steps()), 0.01 );
}

