#include "base/bdmbase.h"
#include "base/user_info.h"
#include "stat/emix.h"
#include "itpp_ext.h"
#include "../pdf_harness.h"
#include "../mat_checks.h"
#include "UnitTest++.h"

using namespace bdm;

static void check_mean(pdf &distrib_obj, const vec &mu0, int nsamples, const vec &mean, double tolerance);

static void check_covariance(mmix &distrib_obj, const vec &mu0, int nsamples, const mat &R, double tolerance);

TEST ( mgamma_test ) {
	pdf_harness::test_config ( "mgamma.cfg" );
}

TEST ( mlnorm_test ) {
	pdf_harness::test_config ( "mlnorm.cfg" );
}

TEST ( mprod_test ) {
	pdf_harness::test_config ( "mprod.cfg" );
}

TEST ( mmix_test ) {
	pdf_harness::test_config ( "mmix.cfg" );
}

TEST ( emix_test ) {
	pdf_harness::test_config ( "emix.cfg" );
}
