function plotestimates(true,means,lb,ub);
% function plots a graph of estimates with lower and upper bounds

ndat = size(means,1);

if size(true,1)==1 % constant value
    true = ones(ndat,1)*true;
end


hold off
plot(true,'-.');
hold on
plot(means(1:ndat,:));
co = get(gca,'ColorOrder');
for i=1:size(means,2)
    ind =1:floor(ndat/20):ndat; % 20 bars in picture
    h=errorbar(ind,means(ind,i),...
    means(ind,i)-lb(ind,i),means(ind,i)-ub(ind,i),'.');
    set(h,'color',co(i,:));
end
