#include "ctrlbase.h"

namespace bdm{

void LQG::set_system(shared_ptr<StateSpace<chmat> > S0){
	S = S0;
}

void LQG::set_control_parameters(const mat &Qy0, const mat &Qu0, const vec &y_req0, int horizon0){
	Qy=Qy0;
	Qu=Qu0;
	y_req=y_req0;
	horizon = horizon0;
}

void LQG::validate() {
	// set properties from S
	dimx= S->_A().rows();
	dimy= S->_C().rows();
	dimu= S->_B().cols();
	pr=zeros(dimx+dimu+dimy,  dimu+dimx+dimu+dimy);
	pr.set_submatrix(dimx, dimu+dimx, eye(dimu+dimy));
	
	//penalization
	bdm_assert ( Qy.cols() == dimy, "LQG: wrong dimensions of Qy " );
	bdm_assert ( Qu.cols() == dimu, "LQG: wrong dimensions of Qu " );
	bdm_assert ( y_req.length() == dimy, "LQG: wrong dimensions of y_req " );
	
	qux=zeros(dimu,dimx+2*dimu+dimy);     
	qyx=zeros(dimy, dimx+dimy+dimu);
	
	//
	initial_belmann();
	// parts of QR
	post_qr = zeros(pre_qr.rows(), pre_qr.cols());
	
	update_system();
}


}
