function UD = udupdt(UD, r, w);
% update U'DU decomposition update
% U'DU := U'DU+w*r'*r 
% UD     = udupdt(UD, r, w)
% UD     = input upper triangular matrix with unit diagonal replaced
%          by D 
% w      = weight of the updating dyad
% r      = the modifying data vector
%
% Design : L. Tesar Jan 2004
% Updated: Jan 2004
% Project: ProDaCTool
% Calls  : dydrs

if nargin<2, error('udupdt needs at least two input arguments'); end 
if nargin==2, w=1; end
if abs(w)<eps, return; end 
   
[m,n] = size(UD);
if m~=n, error('UD decomposition must be square matrix in udupdt.m'); end
if m~=length(r), error('incorrect dimension of vector to be reduced in udupdt.m'); end

if size(r,1)>1, r=r'; end;

%Test for upper triangularity:
%if max(max(abs(triu(UD',1))));
%   error('must be lower triangular matrix');
%end;

for j=1:m;
   if r(j)~=0;
      [r, UD(j,:), w, UDjj] = dydrs(r,UD(j,:),w,UD(j,j),j,j+1,m);
      UD(j,j) = UDjj;
   end;   
end; 