/*!
\file
\brief wrapper function for epdf.sample_mat()


 */

#include <stat/emix.h>

using namespace bdm;

#ifdef MEX
#include <mex/mex_parser.h>

void mexFunction ( int n_output, mxArray *output[], int n_input, const mxArray *input[] ) {
	// Check the number of inputs and output arguments
	if ( n_input<1 ) mexErrMsgTxt ( "Usage:\n"
		                                "mat=pdf_sample_mat(pdf_struct, nos)\n"
		                                "  pdf_struct = struct('class','pdf_offspring',...);  % description of pdf\n"
		                                "  nos        = 10;                                   % number of samples\n"
		                                "output:\n"
		                                "  matrix of samples, each sample in one column." );

	RV::clear_all();
	//CONFIG
	if (!mxIsStruct(input[0])) mexErrMsgTxt("Given input is not a struct.");

	int nos=10;
	if (n_input>1) {nos = (int)(*mxGetPr(input[1]));}
	
	UImxArray Cfg(input[0]);
	Cfg.writeFile("epdf_sample_mat.cfg");

	shared_ptr<epdf> ep=UI::build<epdf>(Cfg.getRoot());
	
	if ( n_output<1 ) mexErrMsgTxt ( "No output - nothing to do!" );
	output[0] = mxCreateDoubleMatrix(ep->dimension(), nos, mxREAL);
	mat2mxArray(ep->sample_mat(nos), output[0]);
}
#endif
