/*!
\file
\brief wrapper function for epdf.mean()


 */

#include <stat/emix.h>

using namespace bdm;

#ifdef MEX
#include <mex/mex_parser.h>

void mexFunction ( int n_output, mxArray *output[], int n_input, const mxArray *input[] ) {
	// Check the number of inputs and output arguments
	if ( n_input<1 ) mexErrMsgTxt ( "Usage:\n"
		                                "vec=pdf_mean(pdf_struct)\n"
		                                "  pdf_struct = struct('class','pdf_offspring',...);  % description of pdf\n"
		                                "output:\n"
		                                "  vec mean value of given pdf." );

	RV::clear_all();
	//CONFIG
	if (!mxIsStruct(input[0])) mexErrMsgTxt("Given input is not a struct.");
		
	UImxArray Cfg(input[0]);
	Cfg.writeFile("epdf_mean.cfg");

	shared_ptr<epdf> ep=UI::build<epdf>(Cfg.getRoot());
	
	
	if ( n_output<1 ) mexErrMsgTxt ( "No output - nothing to do!" );
	output[0] = mxCreateDoubleMatrix(ep->dimension(), 1, mxREAL);
	vec2mxArray(ep->mean(), output[0]);
}
#endif
