/*!
\file
\brief wrapper function for epdf.covariance()


 */

#include <stat/emix.h>

using namespace bdm;

#ifdef MEX
#include <mex/mex_parser.h>

void mexFunction ( int n_output, mxArray *output[], int n_input, const mxArray *input[] ) {
	// Check the number of inputs and output arguments
	if ( n_input<1 ) mexErrMsgTxt ( "Usage:\n"
		                                "vec=pdf_variance(pdf_struct)\n"
		                                "  pdf_struct = struct('class','pdf_offspring',...);  % description of pdf\n"
		                                "output:\n"
		                                "  vec variance of given pdf." );

	RV::clear_all();
	//CONFIG
	UImxArray Cfg(input[0]);
	Cfg.writeFile("epdf_covariance.cfg");

	shared_ptr<epdf> ep=UI::build<epdf>(Cfg);
	
	
	if ( n_output<1 ) mexErrMsgTxt ( "No output - nothing to do!" );
	output[0] = mxCreateDoubleMatrix(ep->dimension(), 1, mxREAL);
	vec2mxArray(ep->variance(), output[0]);
}
#endif
