//
// C++ Interface: osutils
//
// Description: Agr
//
//
// Author: smidl <smidl@utia.cas.cz>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "itpp_ext.h"

using namespace std;

/*!
@brief Function concats name of a directory and file
*/
void get_fname ( char* filename, std::string &dirname, std::string &f );

/*!
@brief Function creates a directory

@param dirname name of the directory to be created
@param rewrite if true then existence of the directory is not an error

Raises std::runtime_error if rewrite is false and dirname already exists.
*/
void makedir ( string &dirname, bool rewrite = true );

/*! @brief Recursively removes directories and files.

@param path the name (absolute or relative) of the file or directory to
be removed (must not be empty).

Returns true on success, false when path couldn't be removed because
it didn't exist, throws an exception otherwise.
*/
bool remove_all ( const char *path );

