#include <string>
#include <sstream>
#include "../bdm/base/bdmbase.h"
#include "UnitTest++.h"

using namespace bdm;

TEST ( rv_test ) {
	RV::clear_all();

	RV a = RV ( "{a_in_test_rv }", "3" );
	CHECK ( a.equal ( a ) );
	CHECK_EQUAL ( 1, a.length() );
	CHECK_EQUAL ( 3, a.size ( 0 ) );
	CHECK_EQUAL ( std::string ( "a_in_test_rv" ), a.name ( 0 ) );

	RV b = RV ( "{b_in_test_rv }", "2" );
	CHECK ( !b.equal ( a ) );
	CHECK_EQUAL ( 0, b.mint() );

	RV c = RV ( "{c_in_test_rv }" );
	CHECK_EQUAL ( 1, c.length() );
	CHECK_EQUAL ( 1, c.size ( 0 ) );

	RV trv = RV ( "{e_in_test_rv f_in_test_rv }", "1 2", "3 4" );
	CHECK_EQUAL ( 2, trv.length() );
	CHECK_EQUAL ( 3, trv.mint() );

	// add a and b
	RV ab = a;
	bool added = ab.add ( b );
	CHECK ( added );
	CHECK_EQUAL ( 2, ab.length() );
	CHECK_EQUAL ( 3, ab.size ( 0 ) );
	CHECK_EQUAL ( std::string ( "a_in_test_rv" ), ab.name ( 0 ) );
	CHECK_EQUAL ( 2, ab.size ( 1 ) );
	CHECK_EQUAL ( std::string ( "b_in_test_rv" ), ab.name ( 1 ) );

	std::stringstream abss;
	abss << ab;
	CHECK_EQUAL ( std::string ( "1(3)=a_in_test_rv_{0}; 2(2)=b_in_test_rv_{0}; " ), abss.str() );

	// concat a, b and c
	RV abc = concat ( ab, c );
	CHECK_EQUAL ( 3, abc.length() );
	std::stringstream abcss;
	abcss << abc;
	CHECK_EQUAL ( std::string ( "1(3)=a_in_test_rv_{0}; 2(2)=b_in_test_rv_{0}; 3(1)=c_in_test_rv_{0}; " ), abcss.str() );

	// structure of a, b, c
	str s = abc.tostr();
	int exp_ids[] = { 1, 1, 1, 2, 2, 3 };
	int exp_sz = sizeof ( exp_ids ) / sizeof ( exp_ids[0] );
	CHECK_EQUAL ( exp_sz, s.ids.size() );
	CHECK_EQUAL ( exp_sz, s.times.size() );
	for ( int i = 0; i < exp_sz; ++i ) {
		CHECK_EQUAL ( exp_ids[i], s.ids ( i ) );
		CHECK_EQUAL ( 0, s.times ( i ) );
	}

	RV slice = abc ( 1, 2 );
	CHECK_EQUAL ( 1, slice.length() );
	CHECK_EQUAL ( 3, slice.size ( 0 ) );
	CHECK_EQUAL ( std::string ( "a_in_test_rv" ), slice.name ( 0 ) );

	// find a in abc
	ivec f = a.findself ( abc );
	CHECK_EQUAL ( 1, f.length() );
	CHECK_EQUAL ( 0, f ( 0 ) );

	// find abc in a
	f = abc.findself ( a );
	int exp_indices[] = { 0, -1, -1 };
	CHECK_EQUAL ( 3, f.length() );
	for ( unsigned i = 0;
	        i < sizeof ( exp_indices ) / sizeof ( exp_indices[0] );
	        ++i ) {
		CHECK_EQUAL ( exp_indices[i], f ( i ) );
	}

	// subtract b from abc
	RV ac = abc.subt ( b );
	std::stringstream acss;
	acss << ac;
	CHECK_EQUAL ( std::string ( "1(3)=a_in_test_rv_{0}; 3(1)=c_in_test_rv_{0}; " ), acss.str() );

	// data index of ac in abc
	ivec di = ac.dataind ( abc );
	int exp_di[] = { 0, 1, 2, 5 };
	exp_sz = sizeof ( exp_di ) / sizeof ( exp_di[0] );
	CHECK_EQUAL ( exp_sz, di.size() );
	for ( int i = 0; i < exp_sz; ++i ) {
		CHECK_EQUAL ( exp_di[i], di ( i ) );
	}

	// subselect
	RV bc = abc ( ivec ( "1 2" ) );
	std::stringstream bcss;
	bcss << bc;
	CHECK_EQUAL ( std::string ( "2(2)=b_in_test_rv_{0}; 3(1)=c_in_test_rv_{0}; " ), bcss.str() );

#if 0
	// actually doesn't select, just reorders the variables -
	// wonder if that's correct...
	bc = abc ( 1, 2 );
	bcss << bc;
	CHECK_EQUAL ( std::string ( "2(2)=b_in_test_rv_{0}; 3(1)=c_in_test_rv_{0}; " ), bcss.str() );
#endif

	// Copy indices between ba and ab
	RV ba = b;
	ba.add ( a );

	ivec ai;
	ivec bi;
	ba.dataind ( ac, ai, bi );

	int exp_ai[] = { 2, 3, 4 };
	exp_sz = sizeof ( exp_ai ) / sizeof ( exp_ai[0] );
	CHECK_EQUAL ( exp_sz, ai.size() );
	for ( unsigned i = 0;
	        i < sizeof ( exp_ai ) / sizeof ( exp_ai[0] );
	        ++i ) {
		CHECK_EQUAL ( exp_ai[i], ai ( i ) );
	}

	int exp_bi[] = { 0, 1, 2 };
	exp_sz = sizeof ( exp_bi ) / sizeof ( exp_bi[0] );
	CHECK_EQUAL ( exp_sz, bi.size() );
	for ( unsigned i = 0;
	        i < sizeof ( exp_bi ) / sizeof ( exp_bi[0] );
	        ++i ) {
		CHECK_EQUAL ( exp_bi[i], bi ( i ) );
	}

	// check uniqueness
	RV join = a;
	join.add ( b );
	RV tmp = a;
	tmp.t_plus ( 1 );
	join.add ( tmp );
	tmp = b;
	tmp.t_plus ( -1 );
	join.add ( tmp );

	CHECK_EQUAL ( unique ( join._ids() ), vec_2 ( a.id ( 0 ), b.id ( 0 ) ) ); // find only ids of a and b
	CHECK_EQUAL ( unique_complement ( join._ids(), vec_1 ( a.id ( 0 ) ) ), vec_1 ( b.id ( 0 ) ) ); // complemnet of a in previous is b

	//test if unique names work
	RV uniq1 ( "y", 1 );
	RV uniq2 ( "y", 1 );

	CHECK_EQUAL ( uniq1.id ( 0 ), uniq2.id ( 0 ) );

	// check scalarname
	CHECK_EQUAL ( "a_in_test_rv_2", abc.scalarname ( 2 ) );
	CHECK_EQUAL ( "b_in_test_rv_0", abc.scalarname ( 3 ) );
}
