
/*!
\file
\brief Multi-Estimator (developped for PMSM)


 */

#include "base/user_info.h"
#include "base/loggers.h"
#include "estim/kalman.h"
#include "pmsmDS.h"
#include "filters.h"
#include "aimsun_bdm/aimsun_ds.h"


using namespace bdm;
int main ( int argc, char* argv[] ) {
	const char *fname;
	if ( argc>1 ) {fname = argv[1];	}
	else { cout << "Missing configuration file.\n Usage: \n $> estimator config_file.cfg"<<endl; abort(); }
	UIFile F ( fname );

	AimsunDS DS;
	shared_ptr<logger> L = UI::build <logger>( F, "logger" );

	L->finalize();

	for (int i=0; i<nE; i++){
		delete Dls(i);
		delete Dlsc(i);
	}
	return 0;
}

