/*!
\file
\brief wrapper function for epdf.marginal()


 */

#include <stat/emix.h>

using namespace bdm;

#ifdef MEX
#include <mex/mex_parser.h>

void mexFunction ( int n_output, mxArray *output[], int n_input, const mxArray *input[] ) {
	// Check the number of inputs and output arguments
	if ( n_input<1 ) mexErrMsgTxt ( "Usage:\n"
		                                "vec=pdf_marginal(pdf_struct, RVs)\n"
		                                "  pdf_struct = struct('class','pdf_offspring',...);  % description of pdf\n"
		                                "  RVs  = RV(...);                                    % description of variables of teh marginal"
		                                "output:\n"
		                                "  pdf_struct = struct('class','marginal_type',...);  % description of marginal pdf." );

	RV::clear_all();
	//CONFIG
	if (n_input<2){mexErrMsgTxt("RVs not given"); }
	
	UImxArray Cfg(input[0]);
	UImxArray RVs(input[1]);
	//Cfg.writeFile("epdf_marginal.cfg");

	shared_ptr<epdf> ep=UI::build<epdf>(Cfg);
	
	if (ep){	
		//if ( n_output<1 ) mexErrMsgTxt ( "No output - nothing to do!" );
		shared_ptr<RV> rv=UI::build<RV>(RVs);
		shared_ptr<epdf> marginal = ep->marginal(*rv);
		UImxArray Out;
		UI::save(marginal, Out);
		output[0]=UImxArray::create_mxArray(Out);
	} else { 
		mexErrMsgTxt ( "Given object is not epdf" );
	}
}
#endif
