/***********************************************

     Nastaveni regulatoru vektoroveho rizeni

     Konstanty a omezovace

     Z. Peroutka

Rev. 31.5.2007
***********************************************/

// maximalni proud
#define Ismax   40.0    // max. proud motoru

// regulatory proudu
#define Kpi     20.            // Kp*Iref/Uref
#define Tii     0.005           // casova konstanta reg. ... Kp*Iref/Uref*TV/Ti
#define MAXi    1199.0
#define Q_Kpi   15
#define Q_Kii   15

// regulator odbuzovani - RUrm  Kp=15, Ti=0.5
#define Kpurm   50.0           // 2.0/Iref ev. sqrt(3)/Iref pro PWM se 3. harmonickou
#define Tiurm   0.05				// 31.5.2007: puvodne 0.01
#define MINurm  (-0.95*Ismax)   //  0.95 ... aby i pi reakci reg. Urm byl motor schopen produkovat moment
#define Tfurm   0.01            // casova konstanta filtru Urm
#define Q_Kpurm 12
#define Q_Kiurm 15
#define Q_Kturm 15              // TV/Tf  ... nechat Q15!!!!

// blok "Vypocet napeti" - "odvazbovaci blok" ... definice systemu
#define Q_Kodv_ud       15              // Wref*Iref/Uref*Ls

// regulator rychlosti
#define Kpw     3.0                     // Kpw*Wref/Iref
#define Tiw     0.1
#define MAXw    Ismax
#define Q_Kpw   7
#define Q_Kiw   15

// model motoru pro vypocet toku a momentu
#define Q_K_Fs          15      // max. Q15 ... Ls*Iref/Fref
#define Q_K_moment      12      // max. Q15 ... kp*p*Fref*Iref/Mref


// filtrace napeti v ss obvodu
#define Tfuc	0.1

// filtrace Isd
#define Tfid	0.1

// prechod mezi algoritmy regulace VARIANTA 1 a VARIANTA 2
#define	prechod_1_2		(2.*M_PI*75.)		// 55Hz ... wme [rad/s]
#define prechod_2_1		(2.*M_PI*70.)		// 50Hz ... wme [rad/s]

// regulator Isq prostednictvim beta - algoritmus VARIANTA 2: Karel (Kp=0.0002, Ti=0.001s)
#define Kpib	0.005
#define Tiib	0.01			
#define MAXbeta	(40./180.*M_PI)		// zatezny uhel omezen na +/- 40st.

// regulator Isd - VAR2 - kompenzace vypocteneho napeti
#define	Kpidb	0
#define	Tiidb	0.1
#define MAXud	50.
#define MINud	(-600.)		// principialne neni nutne omezovat, avsak s ohledem na format Q13 s dostatecnou bezpecnosti uvazovano 600V