/*!
  \file
  \brief DataSource for experiments with Aimsun
  \author Jan Prikryl.

*/

#include <base/loggers.h>

using namespace bdm;

//! Simulator of traffic - AIMSUN
class AimsunDS : public DS
{

protected:
    //! indeces of logged variables
    int L_x, L_ou, L_oy, L_iu, L_optu;
    //! Setpoints of omega in timespans given by dt_prof
    vec profileWw;
    //! Setpoints of Mz in timespans given by dt_prof
    vec profileMz;
    //! time-step for profiles
    double dt_prof;
    //! Number of miliseconds per discrete time step
    int Dt;
    //! options for logging, - log predictions of 'true' voltage
    bool opt_modu;
    //! options for logging, -
	eh_els3hrd * p_rsp;
	//! pointer to realised signal plans stored in local data space of eh_api */

public:
    //! Constructor with fixed sampling period
    AimsunDS ();

    //! Get measurements and signal plans from ELS3 controllers
    void getdata ( vec &dt ) const;

    //! Write new signal plans to ELS3
    void write ( vec &ut );

    //! Wait for new data and copy them out to local buffers
    void step();

    // TODO dodelat void to_setting( Setting &root ) const;
private:
	void AimsunDS::initVGS (
		const vgs_headway_mode headway,
		const TCHAR * entrancePath,
		const TCHAR * sectionStatsPath,
		const TCHAR * globalStatsPath
	);
};
