/*!
  \file
  \brief DataSource for experiments with Aimsun
  \author Jan Prikryl.

*/

/* WIN32 stuff */
#include <windows.h>
#include <stdio.h>
#include <tchar.h>

#include <base/loggers.h>

extern "C" {
  #include "eh_hrd.h"
  #include "vgs_hrd.h"
}

using namespace bdm;

//! Simulator of traffic - AIMSUN
class AimsunDS : public DS
{

protected:
	eh_els3hrd * p_rsp;
	//! pointer to realised signal plans stored in local data space of eh_api */

public:
    //! Constructor with fixed sampling period
    AimsunDS ();

    //! Get measurements and signal plans from ELS3 controllers
    void getdata ( vec &dt ) const;

    //! Write new signal plans to ELS3
    void write ( vec &ut );

    //! Wait for new data and copy them out to local buffers
    void step();

    // TODO dodelat void to_setting( Setting &root ) const;
private:
	void AimsunDS::initVGS (
		const vgs_headway_mode headway,
		const TCHAR * entrancePath,
		const TCHAR * sectionStatsPath,
		const TCHAR * globalStatsPath
	);
};
