/*
 */

/* Class definition */
#include "aimsun_fake.h"

AimsunDS::AimsunDS() : DS()
{

  /* Description of the channels of the data vector. */
  Drv = RV ( "{"
    "495_VA  495_VB   495_VC   495_VD   495_VE   495_VF "
    "495_DVA 495_DVB  495_DVA1 495_DVB1 495_DVC  495_DVD  495_DVE  495_DVF  495_DVF1 "
    "495_S1  495_S2   495_S3   495_S4   495_S5   495_S5a "
    "601_VA  601_VB   601_VC   601_VD   601_VE   601_SE "
	"601_DVA 601_DVAa 601_DVB  601_DVBa 601_DVB1 601_DVC  601_DVD  601_DVD1 601_DSE 601_DVE 601_DSE1 601_DVE1 "
    "601_S6  601_S6a  601_S7   601_S8   601_S9   601_S9a "
    "}",
	"    1,      1,      1,      1,      1,       1,      "
	"    2,      2,      2,      2,      2,       2,      2,      2,      2,"
	"    2,      2,      2,      2,      2,       2,"
	"    1,      1,      1,      1,      1,       1,      "
	"    2,      2,      2,      2,      2,       2,       2,       2,       2,       2,       2,       2,"
	"    2,      2,      2,      2,      2,       2"
	);
  /* Remember the size of the data vector. */
  dtsize = Drv._dsize();

  /* Description of the channels of the input vector. */
  Urv = RV ( "{"
	  "Tc"
	  "495_offset"
	  "495_VA  495_VB   495_VC   495_VD   495_VE   495_VF "
	  "601_offset"
	  "601_VA  601_VB   601_VC   601_VD   601_VE   601_SE "
	  "}" );
  /* Remember the size of the input vector. */
  utsize = Urv._dsize();
  set_log_level(0);
}

void AimsunDS::getdata ( vec &dt ) const
{
	dt = linspace(0.0,double(dtsize),dtsize);
}


void AimsunDS::write ( vec &ut )
{
}


void AimsunDS::step()
{
	
}

