#include "traffic_agent.h"

void SignalGroup::from_setting(const libconfig::Setting& set)
{
UI::get(name,set, "name", UI::compulsory);
UI::get(detectors, set, "detectors", UI::optional);
//
// TODO make some analysis of the detectors

}

void BaseTrafficAgent::from_setting(const Setting& set)
{
    bdm::Participant::from_setting(set);
	
	// load from file
	UI::get(sg,set,"sg", UI::compulsory);
	UI::get(requests,set,"output",UI::compulsory);
	Array<DetectorIn> det_in;
	UI::get(det_in, set, "input",UI::compulsory);
	
	// process sg == create handles
	sgh.set_length(sg.length());
	for(int i=0;i<sg.length();i++){
		sgh(i).connect_sg(sg(i),name);
	}
	
	// process output == handles
	request_handler.set_length(requests.length());
	for(int i=0;i<requests.length();i++){
		request_handler(i).connect_request(requests(i),name);
		output_rv.add(request_handler(i).rv);
	}
	// connect
	for(int i=0;i<requests.length();i++){
		request_handler(i).outdata2out.set_connection(request_handler(i).rv, output_rv);
		// search teh right section == probably inefficient
/*		int j;
		for (j=0;j<sg.length();j++){
			if (sg(i).name==requests(i).from){
				sgh(i).data2out.set_connection(output_rv, sgh(i).det_data);
				break;
			}
		}*/
	}
	
	// process DetIn - create input
	for (int i=0; i<det_in.length(); i++){
		input_rv.add(RV(det_in(i).name,2));
	}
	input_data.set_size(input_rv._dsize());
}
